# ar_sim/common/__init__.py

"""
Shared utilities for the Absolute Relativity simulation framework.

Modules:
- fractal_fits: routines to load and fit fractal‐dimension data.
- kernel_builder: routines to construct reproduction kernels.
"""

from .fractal_fits import (
    load_D_values,
    fit_fractal_curve,
    logistic_D_function,
)
from .kernel_builder import (
    build_reproduction_kernel,
    compute_kernel_eigenvalues,
)
